
#ifndef _TCFFT_H
#define _TCFFT_H

#include <afxtempl.h>


class TCFFT : public CObject
{
	public:	TCFFT(int max_prime_factor = 127);
			TCFFT(TCFFT &CFFT);
			~TCFFT(void);

			int m_max_factor_count;
			int	m_max_prime_factor;
			int m_max_prime_factorDiv2;

			int     groupOffset,dataOffset,blockOffset,adr;
			int     groupNo,dataNo,blockNo,twNo;
			double  omega, tw_re,tw_im;

			double  *twiddleRe;
			double	*twiddleIm;
            double	*trigRe;
			double	*trigIm;
            double	*zRe;
			double	*zIm;
			double  *vRe; 
			double  *vIm;
			double  *wRe; 
			double  *wIm;

			int		m_number_of_points;


			void operator = (TCFFT &CFFT);
	
			void Serialize(CArchive& CArchiveFile);

			bool TransTableSetup(int sofar[], int actual[], int remain[],int *nFact,int *nPoints);
			void Permute(int nPoint, int nFact,int fact[], int remain[],double xRe[], double xIm[],double yRe[], double yIm[]);
			void InitTrig(int radix);
			void FFT_4(double aRe[], double aIm[]);
			void FFT_5(double aRe[], double aIm[]);
			void FFT_8(void);
			void FFT_10(void);
			void FFT_Odd(int radix);
			void TwiddleTransf(int sofarRadix, int radix, int remainRadix, double yRe[], double yIm[]);

			void Factorize(int n, int *nFact, int fact[]);
			bool Calculate(int n, double xRe[], double xIm[],double yRe[], double yIm[]);

			bool AllocateMemory(int number_of_points);
			void DeleteMemory(void);
			void ZeroPointers(void);
			bool CheckMemory(void);

			DECLARE_SERIAL(TCFFT)

};

#endif